/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.CorrelatedVariable;
import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.Expression;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.StatementException;
import com.mckoi.database.TableName;
import com.mckoi.database.Variable;
import com.mckoi.database.interpret.FromTableInterface;
import java.util.ArrayList;

class TableExpressionFromSet {
    private ArrayList table_resources = new ArrayList();
    private ArrayList function_resources = new ArrayList();
    private ArrayList exposed_variables = new ArrayList();
    private boolean case_insensitive = false;
    private TableExpressionFromSet parent;

    public TableExpressionFromSet(DatabaseConnection connection) {
        this.case_insensitive = connection.isInCaseInsensitiveMode();
    }

    public void setParent(TableExpressionFromSet parent) {
        this.parent = parent;
    }

    public TableExpressionFromSet getParent() {
        return this.parent;
    }

    public void setCaseInsensitive(boolean status) {
        this.case_insensitive = status;
    }

    boolean stringCompare(String str1, String str2) {
        if (!this.case_insensitive) {
            return str1.equals(str2);
        }
        return str1.equalsIgnoreCase(str2);
    }

    public void addTable(FromTableInterface table_resource) {
        this.table_resources.add(table_resource);
    }

    public void addFunctionRef(String name, Expression expression) {
        this.function_resources.add(name);
        this.function_resources.add(expression);
    }

    public void exposeVariable(Variable v) {
        this.exposed_variables.add(v);
    }

    public void exposeAllColumnsFromSource(FromTableInterface table) {
        Variable[] v = table.allColumns();
        for (int p = 0; p < v.length; ++p) {
            this.exposeVariable(v[p]);
        }
    }

    public void exposeAllColumns() {
        for (int i = 0; i < this.setCount(); ++i) {
            this.exposeAllColumnsFromSource(this.getTable(i));
        }
    }

    public void exposeAllColumnsFromSource(TableName tn) {
        FromTableInterface table_interface = this.findTable(tn.getSchema(), tn.getName());
        if (table_interface == null) {
            throw new StatementException("Table name found: " + tn);
        }
        this.exposeAllColumnsFromSource(table_interface);
    }

    public Variable[] generateResolvedVariableList() {
        int sz = this.exposed_variables.size();
        Variable[] list = new Variable[sz];
        for (int i = 0; i < sz; ++i) {
            list[i] = new Variable((Variable)this.exposed_variables.get(i));
        }
        return list;
    }

    FromTableInterface findTable(String schema, String name) {
        for (int p = 0; p < this.setCount(); ++p) {
            FromTableInterface table = this.getTable(p);
            if (!table.matchesReference(null, schema, name)) continue;
            return table;
        }
        return null;
    }

    int setCount() {
        return this.table_resources.size();
    }

    FromTableInterface getTable(int i) {
        return (FromTableInterface)this.table_resources.get(i);
    }

    Expression dereferenceAssignment(Variable v) {
        TableName tname = v.getTableName();
        String var_name = v.getName();
        if (tname != null) {
            return null;
        }
        Expression last_found = null;
        int matches_found = 0;
        for (int i = 0; i < this.function_resources.size(); i += 2) {
            String fun_name = (String)this.function_resources.get(i);
            if (!this.stringCompare(fun_name, var_name)) continue;
            if (matches_found > 0) {
                throw new StatementException("Ambiguous reference '" + v + "'");
            }
            last_found = (Expression)this.function_resources.get(i + 1);
            ++matches_found;
        }
        return last_found;
    }

    private Variable resolveAssignmentReference(Variable v) {
        TableName tname = v.getTableName();
        String var_name = v.getName();
        if (tname != null) {
            return null;
        }
        Variable last_found = null;
        int matches_found = 0;
        for (int i = 0; i < this.function_resources.size(); i += 2) {
            String fun_name = (String)this.function_resources.get(i);
            if (!this.stringCompare(fun_name, var_name)) continue;
            if (matches_found > 0) {
                throw new StatementException("Ambiguous reference '" + v + "'");
            }
            last_found = new Variable(fun_name);
            ++matches_found;
        }
        return last_found;
    }

    Variable resolveTableColumnReference(Variable v) {
        TableName tname = v.getTableName();
        String sch_name = null;
        String tab_name = null;
        String col_name = v.getName();
        if (tname != null) {
            sch_name = tname.getSchema();
            tab_name = tname.getName();
        }
        Variable matched_var = null;
        for (int i = 0; i < this.table_resources.size(); ++i) {
            FromTableInterface table = (FromTableInterface)this.table_resources.get(i);
            int rcc = table.resolveColumnCount(null, sch_name, tab_name, col_name);
            if (rcc == 0) continue;
            if (rcc == 1 && matched_var == null) {
                matched_var = table.resolveColumn(null, sch_name, tab_name, col_name);
                continue;
            }
            System.out.println(matched_var);
            System.out.println(rcc);
            throw new StatementException("Ambiguous reference '" + v + "'");
        }
        return matched_var;
    }

    Variable resolveReference(Variable v) {
        int list_size;
        Variable tc_var;
        ArrayList<Variable> list = new ArrayList<Variable>();
        Variable function_var = this.resolveAssignmentReference(v);
        if (function_var != null) {
            list.add(function_var);
        }
        if ((tc_var = this.resolveTableColumnReference(v)) != null) {
            list.add(tc_var);
        }
        if ((list_size = list.size()) == 0) {
            return null;
        }
        if (list_size == 1) {
            return (Variable)list.get(0);
        }
        throw new StatementException("Ambiguous reference '" + v + "'");
    }

    CorrelatedVariable globalResolveReference(int level, Variable v) {
        Variable nv = this.resolveReference(v);
        if (nv == null && this.getParent() != null) {
            return this.getParent().globalResolveReference(level + 1, v);
        }
        if (nv != null) {
            return new CorrelatedVariable(nv, level);
        }
        return null;
    }

    Object qualifyVariable(Variable v_in) {
        Variable v = this.resolveReference(v_in);
        if (v == null) {
            if (this.getParent() != null) {
                CorrelatedVariable cv = this.getParent().globalResolveReference(1, v_in);
                if (cv == null) {
                    throw new StatementException("Reference '" + v_in + "' not found.");
                }
                return cv;
            }
            if (v == null) {
                throw new StatementException("Reference '" + v_in + "' not found.");
            }
        }
        return v;
    }

    ExpressionPreparer expressionQualifier() {
        return new ExpressionPreparer(){

            public boolean canPrepare(Object element) {
                return element instanceof Variable;
            }

            public Object prepare(Object element) throws DatabaseException {
                return TableExpressionFromSet.this.qualifyVariable((Variable)element);
            }
        };
    }
}

